/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.api;

import com.mojang.logging.LogUtils;
import crystalspider.harvestwithease.config.ModConfig;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public final class HarvestWithEaseAPI {
    private static final Logger LOGGER = LogUtils.getLogger();

    private HarvestWithEaseAPI() {
    }

    public static boolean isCrop(Block block) {
        return block instanceof CropBlock || block instanceof NetherWartBlock || block instanceof CocoaBlock || ModConfig.getCrops().contains(HarvestWithEaseAPI.getKey(block));
    }

    public static IntegerProperty getAge(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (IntegerProperty)blockState.m_61147_().stream().filter(property -> property.m_61708_().equals("age")).findFirst().orElseThrow();
    }

    public static boolean isMature(BlockState blockState, IntegerProperty age) {
        return blockState.m_61145_((Property)age).orElse(0) >= (Integer)Collections.max(age.m_6908_());
    }

    public static boolean isMature(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestWithEaseAPI.isMature(blockState, HarvestWithEaseAPI.getAge(blockState));
    }

    public static boolean isTallCrop(Level level, BlockState blockState, BlockPos blockPos) {
        return blockState.m_204336_(BlockTags.f_13073_) && level.m_8055_(blockPos.m_7495_()).m_60713_(blockState.m_60734_()) || level.m_8055_(blockPos.m_7494_()).m_60713_(blockState.m_60734_());
    }

    public static boolean isTierForMultiHarvest(TieredItem tool) {
        Tier toolTier = tool.m_43314_();
        ResourceLocation id = TierSortingRegistry.getName((Tier)toolTier);
        String configTier = ModConfig.getMultiHarvestStartingTier();
        return configTier.equalsIgnoreCase("none") || toolTier.toString().equalsIgnoreCase(configTier) || id != null && (id.toString().equalsIgnoreCase(configTier) || HarvestWithEaseAPI.isTierIn((List<Tier>)TierSortingRegistry.getTiersLowerThan((Tier)toolTier), configTier));
    }

    public static boolean isTierIn(List<Tier> tiers, String tierRef) {
        return tiers.stream().anyMatch(tier -> HarvestWithEaseAPI.matchesTier(tierRef, tier));
    }

    public static boolean isTierIn(List<Tier> tiers, ResourceLocation tierRef) {
        return HarvestWithEaseAPI.isTierIn(tiers, tierRef.toString());
    }

    public static boolean isTierIn(List<Tier> tiers, Tier tier) {
        return HarvestWithEaseAPI.isTierIn(tiers, tier.toString());
    }

    public static int getTierLevel(Tier tier) {
        return TierSortingRegistry.getTiersLowerThan((Tier)tier).size() + 1;
    }

    public static int getTierLevel(ResourceLocation tierRef) {
        return HarvestWithEaseAPI.getTierLevel(TierSortingRegistry.byName((ResourceLocation)tierRef));
    }

    public static int getTierLevel(String tierRef) {
        try {
            return tierRef.equalsIgnoreCase("none") ? -1 : HarvestWithEaseAPI.getTierLevel(TierSortingRegistry.getSortedTiers().stream().filter(tier -> HarvestWithEaseAPI.matchesTier(tierRef, tier)).findFirst().orElseThrow());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static boolean matchesTier(String tierRef, Tier tier) {
        return tier.toString().equalsIgnoreCase(tierRef) || TierSortingRegistry.getName((Tier)tier).toString().equalsIgnoreCase(tierRef);
    }

    private static String getKey(Block block) {
        ResourceLocation blockLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockLocation != null) {
            return blockLocation.toString();
        }
        LOGGER.debug("Couldn't get key for block [" + block + "].");
        return "";
    }
}

